#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//3D Twirly ThingsMod01.fsh   by   SnoopethDuckDuck  
//https://www.shadertoy.com/view/ss2cRz
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define MAX_STEPS 400
#define MAX_DIST 20.
#define SURF_DIST .001

#define S smoothstep
#define T iTime
// start Common //
#define pi 3.14159

float thc(float a, float b) {
    return tanh(a * cos(b)) / tanh(a);
}

float ths(float a, float b) {
    return tanh(a * sin(b)) / tanh(a);
}

vec2 thc(float a, vec2 b) {
    return tanh(a * cos(b)) / tanh(a);
}

vec2 ths(float a, vec2 b) {
    return tanh(a * sin(b)) / tanh(a);
}

vec3 pal( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d )
{
    return a + b*cos( 6.28318*(c*t+d) );
}

float h21 (vec2 a) {
    return fract(sin(dot(a.xy, vec2(12.9898, 78.233))) * 43758.5453123);
}

float mlength(vec2 uv) {
    return max(abs(uv.x), abs(uv.y));
}

float mlength(vec3 uv) {
    return max(max(abs(uv.x), abs(uv.y)), abs(uv.z));
}

// (SdSmoothMin) stolen from here: https://www.shadertoy.com/view/MsfBzB
float smin(float a, float b)
{
    float k = 0.12;
    float h = clamp(0.5 + 0.5 * (b-a) / k, 0.0, 1.0);
    return mix(b, a, h) - k * h * (1.0 - h);
}
// end Common //
mat2 Rot(float a) {
    float s=sin(a), c=cos(a);
    return mat2(c, -s, s, c);
}

float sdBox(vec3 p, vec3 s) {
    p = abs(p)-s;
	return length(max(p, 0.))+min(max(p.x, max(p.y, p.z)), 0.);
}

float GetDist(vec3 p) {
    vec2 uv = p.xz;
   
    uv *= Rot(0.18 * p.y + 0.18 * cos(1.5 * iTime + 2. * p.y + 0.2 * dot(uv, uv)));
    uv = abs(uv) - 1.6;
    
    float time = iTime + 2. * p.y;
    float sc = 2.; //length(uv) * 32.;
    
    float r = 0.05;
    //r += 0.05 * cos(4. * length(uv));
    float sp = 1.;
    float n = 7.;
    float d = 100.;
    for (float i = 0.; i < n; i++) {
        float e = (i/n) * pi;
        vec2 p = 0.5 * cos(time + e + 0.25 * pi * cos(iTime + 2. * e)) * vec2(cos(e), sin(e));
        d = smin(d, length(uv - p) - 0.1 - 0.05 * cos(iTime + 10. * p.y + e));
    }

    return 0.7 * d;
}

float RayMarch(vec3 ro, vec3 rd) {
	float dO=0.;
    
    for(int i=0; i<MAX_STEPS; i++) {
    	vec3 p = ro + rd*dO;
        float dS = GetDist(p);
        dO += dS;
        if(dO>MAX_DIST || abs(dS)<SURF_DIST) break;
    }
    
    return dO;
}

vec3 GetNormal(vec3 p) {
	float d = GetDist(p);
    vec2 e = vec2(.001, 0);
    
    vec3 n = d - vec3(
        GetDist(p-e.xyy),
        GetDist(p-e.yxy),
        GetDist(p-e.yyx));
    
    return normalize(n);
}

vec3 GetRayDir(vec2 uv, vec3 p, vec3 l, float z) {
    vec3 f = normalize(l-p),
        r = normalize(cross(vec3(0,1,0), f)),
        u = cross(f,r),
        c = f*z,
        i = c + uv.x*r + uv.y*u,
        d = normalize(i);
    return d;
}

float GetLight(vec3 p, vec3 lightPos) {
   // vec3 lightPos = vec3(0, 5, 6);
    //lightPos.xz += vec2(sin(iTime), cos(iTime))*2.;
    vec3 l = normalize(lightPos-p);
    vec3 n = GetNormal(p);
    
    float dif = clamp(dot(n, l), 0., 1.);
    float d = RayMarch(p+n*SURF_DIST*2., l);
    dif = 0.2 + 0.8 * dif * step(length(lightPos-p), d);
   // if(d<length(lightPos-p)) dif = 0.;
    
    return dif;
}

vec3 Bg(vec3 rd) {
    float k = 0.5 + 0.5 * rd.y;
   // k = smoothstep(0., 1., k);
    
    vec3 e = vec3(1.);
    vec3 col = pal(0.9 * rd.y - 0.08, vec3(k), e, vec3(k), 1.15 * vec3(0.,0.33,0.66));
    
    //col = mix(col, vec3(1.), k);
    return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
	vec2 m = iMouse.xy/iResolution.xy;

    float l = 0.5 + 0.5 * thc(3., 0.5 * iTime);

    float r = 5.;
    float time = 0.25 * iTime;
    vec3 ro = vec3(r * cos(time), 0. * iTime, r * sin(time));
    //ro.yz *= Rot(-m.y*3.14+1.);
    //ro.xz *= Rot(-m.x*6.2831);
    
    vec3 rd = GetRayDir(uv, ro, vec3(0), 1.2);
    vec3 col = vec3(0);
   
    float d = RayMarch(ro, rd);

    if(d<MAX_DIST) {
        vec3 p = ro + rd * d;
        vec3 n = GetNormal(p);
        vec3 r = reflect(rd, n);

        float ambient = .3;
        float difPower = .4;
        //float dif = max(dot(n, normalize(vec3(1,2,3))), 0.);
       // col = vec3(dif*difPower + ambient);

        //float dif2 = GetLight(p, vec3(0.));
       // col *= 1. * vec3(dif2);

        //col *= texture2D(texture0,r).rgb;
        float k = 0.5;
        col = vec3(smoothstep(-k, k, r.y -n.y));
        //col = clamp(col, 0., 1.);

        vec3 e = vec3(1.);
        col *= pal(r.y * 0.25, col, e, col, 1.15 *vec3(0.,0.33,0.66));
        col *= 0.9 + 0.1 * h21(p.xz);
        //col += mix(col, Bg(rd), 0.58* length(n.xz));
    }
    else { 
      //  col = Bg(rd);
      /*
       float d = length(uv);
       float k = 1./iResolution.y;
       float s = smoothstep(-k, k, -abs(d-0.4) + 0.01);
       col = vec3(s);
       */
    }

    col = pow(col, vec3(.4545));	// gamma correction
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

